package kom.itbeankit.nw.ethernet;

import java.awt.*;
import kom.itbeankit.common.vcr.ClkListener;
import kom.itbeankit.common.vcr.ClkEvent;
public interface EthernetInterface extends java.io.Serializable
{
    //Color codes
    //use example: setColor(new Color(COLOR_LIGHTGRAY))
    static final int  COLOR_LIGHTGRAY       = 13684194;
    static final int  COLOR_GRAY            = 8421504;
    static final int  COLOR_GRAY_BLUE       = -16750704;
    static final int  COLOR_YELLOW          = 16776960;
    static final int  COLOR_RED             = 16711680;
    static final int  COLOR_DARKGRAY_BLUE   = -16760704;
    static final int  COLOR_DARKYELLOW      = 14014979;
    static final int  COLOR_DARKRED         = 14157313;

    //Data Types
    //important: the sum of two non-collision datatypes
    //should be >= DATATYPE_COLLISION
    static final int  DATA_TYPE_NONE         = 0;
    static final int  DATA_TYPE_IDLE         = 0;
    static final int  DATA_TYPE_DATA         = 2;
    static final int  DATA_TYPE_PADDING      = 3;
    static final int  DATA_TYPE_COLLISION    = 4;

    //Data Colors
    static final int  DATA_COLOR_NONE            = COLOR_LIGHTGRAY;
    static final int  DATA_COLOR_IDLE            = COLOR_LIGHTGRAY;
    static final int  DATA_COLOR_DATA            = COLOR_GRAY_BLUE;
    static final int  DATA_COLOR_PADDING         = COLOR_YELLOW;
    static final int  DATA_COLOR_COLLISION       = COLOR_RED;
    static final int  DATA_COLOR_DATA_DARK       = COLOR_DARKGRAY_BLUE;
    static final int  DATA_COLOR_PADDING_DARK    = COLOR_DARKYELLOW;
    static final int  DATA_COLOR_COLLISION_DARK  = COLOR_DARKRED;

    //Signal status
    static final int  SIGNAL_STATUS_OFF    = 0;
    static final int  SIGNAL_STATUS_ON     = 1;
    static final int  SIGNAL_STATUS_ALARM  = 2;

    //Signal colors for LEDS
    static final int  SIGNAL_COLOR_ALARM = COLOR_RED;
    static final int  SIGNAL_COLOR_ON    = COLOR_YELLOW;
    static final int  SIGNAL_COLOR_OFF   = COLOR_GRAY;

    //Arrow status
    static final int  ARROW_STATUS_OFF             = 0;
    static final int  ARROW_STATUS_COUNTDOWN_UP    = 1;
    static final int  ARROW_STATUS_THICK_UP        = 2;
    static final int  ARROW_STATUS_COUNTDOWN_DOWN  = -1;
    static final int  ARROW_STATUS_THICK_DOWN      = -2;

    //Host colors
    static final int  HOST_COLOR_IDLE       = DATA_COLOR_IDLE;  //light gray-blue
    static final int  HOST_COLOR_PASSIVE    = DATA_COLOR_IDLE;  //light gray-blue
    static final int  HOST_COLOR_ACTIVE     = DATA_COLOR_DATA;  //dark gray-blue

    //Host Operating Modes
    //PASSIVE MODES
    static final int  HOST_STATUS_IDLE              = 0;
    static final int  HOST_STATUS_COUNTDOWN         = 1;
    static final int  HOST_STATUS_CARRIER_SENSE     = 2;

    //ACTIVE MODES
    static final int  HOST_STATUS_ACTIVE            = 10;
    static final int  HOST_STATUS_RECEIVING_DATA    = 11;
    static final int  HOST_STATUS_RECEIVING_PAD     = 12;
    static final int  HOST_STATUS_SENDING_DATA      = 13;
    static final int  HOST_STATUS_SENDING_PAD       = 14;
    static final int  HOST_STATUS_SENDING_NOISE     = 15;

    //Destination Hosts
    static final int  HOST_ADDRESS_NONE         = -1;
    static final int  HOST_ADDRESS_BROADCAST    = 0;

    //Frame Sizes
    static final int  FRAME_SIZE_NORMAL         = 56;
    static final int  FRAME_SIZE_SHORT          = 16;
    static final int  FRAME_SIZE_LONG           = 192;
    static final int  FRAME_SIZE_NOISE          = 24;

    //important should be >10
    static final double  RANDOM_TIME_SCALE      = 49.99;
    static final int  MAX_COLLISION_COUNT       = 10;

    //ethernet scenarios
    //values are important and should not be changed
    //they are the same as choice positions
    static final int  SCENARIO_NONE            = 0;
    static final int  SCENARIO_NORMAL          = 1;
    static final int  SCENARIO_COLLISION       = 2;
    static final int  SCENARIO_BROADCAST       = 3;
    static final int  SCENARIO_SHORT_FRAME     = 4;
    static final int  SCENARIO_FAIRNESS        = 5;

}